<?php
/*
Template Name: Video Gallery Template
*/
get_header();


?>


<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/video_gallery.css">

<div class="container-fluid main-video-container">
    <div class="container mb-5 video-main-container pt-lg-5 pt-1">
        <div class="accordion" id="accordionExample">
            <!-- KEP 2024 -->
            <div class="accordion-item my-4">
                <h2 class="accordion-header" id="headingOne">
                    <button class="accordion-button" type="button" data-bs-toggle="show" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                        The Kandy Esala Perahera 2024
                    </button>
                </h2>

                <!-- 2024 - Sinhala -->
                <div id="collapseOne" class="accordion-collapse" aria-labelledby="headingOne" mb-4>
                    <div class="accordion-body">
                        <h5 class="mt-4 text-center">Kandy Esala Perahera 2024 (Sinhala Narration)</h5>
                        <div id="playlist-2024-sinhala">
                            <div class="row">
                                <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                    <div id="video-dis">
                                        <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-12 video-list-container">
                                    <div id="v-list" class="video-li">
                                        <div class="vli-info">
                                            <div class="upper-info">
                                                <div class="li-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 <span class="video-count"></span></div>
                                                </div>
                                                <div class="drop-icon" id="drop-icon-2024"></div>
                                            </div>
                                        </div>
                                        <div class="vli-videos">
                                            <div class="video-con active-con" data-video="https://www.youtube.com/embed/v8-APF8lPlY?si=zlPLOeGwjPxFj7eb">
                                                <div class="index title">1</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | පළමු කුඹල් පෙරහර | LIVE</div>
                                                </div>
                                            </div>
                                            <div class="video-con" data-video="https://www.youtube.com/embed/O3qXGl5hPKk?si=9oShoyr98bsJBkEC">
                                                <div class="index title">2</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | දෙවෙනි කුඹල් පෙරහර | LIVE</div>
                                                </div>
                                            </div>
                                            <div class="video-con" data-video="https://www.youtube.com/embed/3uByEpBX87g?si=sMkFNBLhF-gCHODf">
                                                <div class="index title">3</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | තුන්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/_h2IT8Pkst4?si=tLHs94VkYIZymPa9">
                                                <div class="index title">4</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | සිව්වෙනි කුඹල් පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/F8k8nXsUbtI?si=SXFz6xxW5L9LD07q">
                                                <div class="index title">5</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | අවසන් කුඹල් පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/csu6ADYnYyA?si=dLMKWF1YZpoYkBgu">
                                                <div class="index title">6</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | පළමු රන්දෝලි පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/5A2aoVVIwpg?si=q1sGIfbsU1YKpqpz">
                                                <div class="index title">8</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | දෙවෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/Ih0z2tbNAT4?si=dSc6RxgGRZmnuJrV">
                                                <div class="index title">9</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | තුන්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/_h2IT8Pkst4?si=NE0lPATP99Vb6sli">
                                                <div class="index title">10</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | සිව්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/0YFk3ubFf8Q?si=thMT8VpgGY3A71ac">
                                                <div class="index title">11</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2024 | අවසන් මහ රන්දෝලි පෙරහර | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/G9gOwvlSzHA?si=fQswSEqPi4lfNkwB">
                                                <div class="index title">12</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">දහවල් පෙරහර| LIVE</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- 2024 - English -->
                <div id="collapseOne" class="accordion-collapse" aria-labelledby="headingOne" mb-4>
                    <div class="accordion-body">
                        <h5 class="mt-4 text-center">Kandy Esala Perahera 2024 (English Narration)</h5>
                        <div id="playlist-2024-english">
                            <div class="row">
                                <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                    <div id="video-dis">
                                        <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-12 video-list-container">
                                    <div id="v-list" class="video-li">
                                        <div class="vli-info">
                                            <div class="upper-info">
                                                <div class="li-titles">
                                                    <div class="title">The Kandy Esala Perahera 2024 <span class="video-count"></span></div>
                                                </div>
                                                <div class="drop-icon" id="drop-icon-2024"></div>
                                            </div>
                                        </div>
                                        <div class="vli-videos">
                                            <div class="video-con active-con" data-video="https://www.youtube.com/embed/HzkHDILVfHM">
                                                <div class="index title">1</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The First Kumbal Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/FE_fBbR8x-A">
                                                <div class="index title">2</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Second Kumbal Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/jjCvXa1Qvjs">
                                                <div class="index title">3</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Third Kumbal Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/TLu6VmDsWlY">
                                                <div class="index title">4</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Fourth Kumbal Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/NG01W6l3so8">
                                                <div class="index title">5</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Fifth Kumbal Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/cECnbmUW6ag">
                                                <div class="index title">6</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The First Randoli Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/nIp0jVgDtDU">
                                                <div class="index title">8</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Second Randoli Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/kkxciUWtfVc">
                                                <div class="index title">9</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Third Randoli Procession 2024 | LIVE</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/sEfM8Gdl2K8">
                                                <div class="index title">10</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Fourth Randoli Procession 2024 | LIVE</div>
                                                </div>
                                            </div>
                                            <div class="video-con" data-video="https://www.youtube.com/embed/AYPT046fYs4">
                                                <div class="index title">11</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Grand Randoli Procession 2024 | LIVE</div>
                                                </div>
                                            </div>
                                            <div class="video-con" data-video="https://www.youtube.com/embed/PKYn2XufjtU">
                                                <div class="index title">12</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">The Day Procession 2024| LIVE</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- 2024 - Tamil -->
                <div id="collapseOne" class="accordion-collapse" aria-labelledby="headingOne" mb-4>
                    <div class="accordion-body">
                        <h5 class="mt-4 text-center">Kandy Esala Perahera 2024 (Tamil Narration)</h5>
                        <div id="playlist-2024-tamil">
                            <div class="row">
                                <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                    <div id="video-dis">
                                        <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-12 video-list-container">
                                    <div id="v-list" class="video-li">
                                        <div class="vli-info">
                                            <div class="upper-info">
                                                <div class="li-titles">
                                                    <div class="title">கண்டி எசல பெரஹெரா 2024 <span class="video-count"></span></div>
                                                </div>
                                                <div class="drop-icon" id="drop-icon-2024"></div>
                                            </div>
                                        </div>
                                        <div class="vli-videos">
                                            <div class="video-con active-con" data-video="https://www.youtube.com/embed/P-i3aMJ_akE">
                                                <div class="index title">1</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">கண்டி எசல பெரஹரா 2024 | முத</div>
                                                </div>
                                            </div>
                                            <div class="video-con" data-video="https://www.youtube.com/embed/P-i3aMJ_akE">
                                                <div class="index title">2</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">இரண்டாவது கும்பல் பெரஹரா</div>
                                                </div>
                                            </div>
                                            <div class="video-con" data-video="https://www.youtube.com/embed/MBKPfnlMgIc">
                                                <div class="index title">3</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">மூன்றாவது கும்பல் பெரஹரா</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/jrulzIqf74Y">
                                                <div class="index title">4</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">நான்காவது கும்பல் பெரஹரா</div>
                                                </div>
                                            </div>
                                            <div class="video-con" data-video="https://www.youtube.com/embed/7JfsVnJMaho">
                                                <div class="index title">5</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">இரண்டாவது ரந்தோலி பெரஹரா</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/fvfzTwKWXiI">
                                                <div class="index title">6</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">முதலாவது ரந்தோலி பெரஹரா</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/7JfsVnJMaho">
                                                <div class="index title">8</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">இரண்டாவது ரந்தோலி பெரஹரா</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/Vz9YKz2MPOU">
                                                <div class="index title">9</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">மூன்றாவது ரந்தோலி பெரஹரா</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/TXTPrLbCPVw">
                                                <div class="index title">10</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">நான்காவது ரந்தோலி பெரஹரா</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/85vDrGy7m2o">
                                                <div class="index title">11</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">இறுதி ரந்தோலி பெரஹரா | நேரலை</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/85vDrGy7m2o">
                                                <div class="index title">12</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">நாள் பெரஹரா</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- 2024 - Multilingual -->
                <div id="collapseOne" class="accordion-collapse" aria-labelledby="headingOne" mb-4>
                    <div class="accordion-body">
                        <h5 class="mt-4 text-center">Grand Randoli Perahera 2024 (Multilingual Narrations)</h5>
                        <div id="playlist-2024-mul">
                            <div class="row">
                                <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                    <div id="video-dis">
                                        <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-12 video-list-container">
                                    <div id="v-list" class="video-li">
                                        <div class="vli-info">
                                            <div class="upper-info">
                                                <div class="li-titles">
                                                    <div class="title">The Kandy Esala Perahera 2024 <span class="video-count"></span></div>
                                                </div>
                                                <div class="drop-icon" id="drop-icon-2024"></div>
                                            </div>
                                        </div>
                                        <div class="vli-videos">
                                            <div class="video-con active-con" data-video="https://www.youtube.com/embed/zYkcRfihIIw">
                                                <div class="index title">1</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">Chinese ( 中國人 )</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/1NRaxrk0rSI">
                                                <div class="index title">2</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">Hindi (हिन्दी)</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/bpvjtyHkue0">
                                                <div class="index title">3</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">Japanese (日本人)</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/GOouevSMNC4">
                                                <div class="index title">4</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">German (Deutsch)</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/LV9MdZTjHfo">
                                                <div class="index title">5</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">Thai (ไทย)</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/4qDT1qgRjVM">
                                                <div class="index title">6</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">French</div>
                                                </div>
                                            </div>

                                            <div class="video-con" data-video="https://www.youtube.com/embed/zYkcRfihIIw">
                                                <div class="index title">8</div>
                                                <div class="thumb">
                                                    <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                </div>
                                                <div class="v-titles">
                                                    <div class="title">Korean</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>



            <!-- Another Playlist for 2023 -->
            <div class="accordion-item my-4">
                <h2 class="accordion-header" id="headingTwo">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                        The Kandy Esala Perahera 2023
                    </button>
                </h2>
                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                    <div class="accordion-body">

                        <!-- 2023 - Sinhala -->
                        <div id="collapseTwo" class="accordion-collapse" aria-labelledby="headingTwo" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Kandy Esala Perahera 2023 (Sinhala Narration)</h5>
                                <div id="playlist-2023-sinhala">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2023"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/KCMlAOZe-k0?si=_r2j0gSqgHHX2HFa">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | පළමු කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/5H_C2Pjr1hc?si=TmQjxKOouqp-3cEC">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | දෙවෙනි කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/rYWbPI6zfno?si=YwNIMqI5kjWFNhtd">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | තුන්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/_RuvZ1QEXyI?si=GFU-9LU3yyCVEhxL">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | සිව්වෙනි කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/2Yik6w8nhbg?si=onKTfnhNJWyAIVSk">
                                                        <div class="index title">5</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | අවසන් කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/5Zdvq05tM-4?si=Cg5DjJB4GFlCRa2q">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | පළමු රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/OaCk9QiWm8k?si=dLi69A-1mZ_0d7yc">
                                                        <div class="index title">8</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | දෙවෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/9qlA1byXtBE?si=v3mNG6KVof8WFFrs">
                                                        <div class="index title">9</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | තුන්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/GNQu-VLbqBQ">
                                                        <div class="index title">10</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | සිව්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/zv8eFESoPj4">
                                                        <div class="index title">11</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2023 | අවසන් මහ රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/_THLBPb1RxQ">
                                                        <div class="index title">12</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">දහවල් පෙරහර 2023| LIVE</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 2023 - English -->
                        <div id="collapseTwo" class="accordion-collapse" aria-labelledby="headingTwo" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Kandy Esala Perahera 2023 (English Narration)</h5>
                                <div id="playlist-2023-english">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">The Kandy Esala Perahera 2023 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2023"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/vs2arK2dEkQ">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The First Kumbal Procession 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/d1mQcZBSbd8">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Second Kumbal Process 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/LTkl_N6IdUY">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Third Kumbal Processio 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/WzSRtqK_3i0">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Fourth Kumbal Processi 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/tEBqVhIt-8M">
                                                        <div class="index title">5</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Fifth Kumbal Procession </div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/j_Gi06e5jQ8">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The First Randoli Procession 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/HXSz3XZQsK0">
                                                        <div class="index title">8</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Second Randoli Procession 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/uF3BYPUz77E">
                                                        <div class="index title">9</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Third Randoli Procession 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/EzqYf8KOxgY">
                                                        <div class="index title">10</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Fourth Randoli Procession 2023</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/Ciq1M7rANHE">
                                                        <div class="index title">11</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Grand Randoli Procession 2023 </div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/4rDSd9wG1pQ">
                                                        <div class="index title">12</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Day Procession 2023</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 2023 - Tamil -->
                        <div id="collapseTwo" class="accordion-collapse" aria-labelledby="headingTwo" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Kandy Esala Perahera 2023 (Tamil Narration)</h5>
                                <div id="playlist-2023-tamil">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2024 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2023"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/GhDZWf9RBcQ">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹரா 2023 | முத</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/HlV5qmIF1cU">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">இரண்டாவது கும்பல் பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/_S69bkieKPk">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">மூன்றாவது கும்பல் பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/qGlgUouJz8Y">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">நான்காவது கும்பல் பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/I0KLQKID7_U">
                                                        <div class="index title">5</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">இரண்டாவது ரந்தோலி பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/deHOdev9bo4">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">முதலாவது ரந்தோலி பெரஹரா</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/nLnkj9KhVAw">
                                                        <div class="index title">8</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">இரண்டாவது ரந்தோலி பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/vQWh-_LijOg">
                                                        <div class="index title">9</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">மூன்றாவது ரந்தோலி பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/Omz3HrGGfmw">
                                                        <div class="index title">10</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">நான்காவது ரந்தோலி பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/EJAMDiShroA">
                                                        <div class="index title">11</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">இறுதி ரந்தோலி பெரஹரா | நேரலை</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/PFzlv29sytA">
                                                        <div class="index title">12</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">நாள் பெரஹரா</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 2023 - Multilingual -->
                        <div id="collapseTwo" class="accordion-collapse" aria-labelledby="headingTwo" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Grand Randoli Perahera 2023 (Multilingual Narrations)</h5>
                                <div id="playlist-2023-mul">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">The Kandy Esala Perahera 2023 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2023"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/DIkuWmaVPik">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">Chinese ( 中國人 )</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/Gd46jfgSeRo">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">Hindi (हिन्दी)</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/WjgO55M-lmw">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">Japanese (日本人)</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/qMbQQelTUPg">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">German (Deutsch)</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/t8a5Czn1mqM">
                                                        <div class="index title">5</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">Thai (ไทย)</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/6UBpSp46n8c">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">French</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Another Playlist for 2022 -->
            <div class="accordion-item my-4">
                <h2 class="accordion-header" id="headingFour">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                        The Kandy Esala Perahera 2022
                    </button>
                </h2>
                <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                    <div class="accordion-body">
                        <!-- 2022 - Sinhala -->
                        <div id="collapseThree" class="accordion-collapse" aria-labelledby="headingThree" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Kandy Esala Perahera 2022 (Sinhala Narration)</h5>
                                <div id="playlist-2022-sinhala">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2022"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/58T8W5NH4Us">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | පළමු කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/vD4jJMiVfgw">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | දෙවෙනි කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/lv-G68ns2os">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | තුන්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/bY4hJvMVcnY">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | සිව්වෙනි කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/r-oogUhtD9w">
                                                        <div class="index title">5</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | අවසන් කුඹල් පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/q4eb0fgZ5Vc">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | පළමු රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/1HBSrZhgnGw">
                                                        <div class="index title">8</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | දෙවෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/5sESO8R0jSE">
                                                        <div class="index title">9</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | තුන්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/TaSy6drdNpU">
                                                        <div class="index title">10</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | සිව්වෙනි රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/5ealuDkr37g">
                                                        <div class="index title">11</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">කන්ද උඩරට ඇසළ පෙරහර 2022 | අවසන් මහ රන්දෝලි පෙරහර | LIVE</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 2022 - English -->
                        <div id="collapseOhree" class="accordion-collapse" aria-labelledby="headingOhree" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Kandy Esala Perahera 2022 (English Narration)</h5>
                                <div id="playlist-2022-english">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">The Kandy Esala Perahera 2023 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2023"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/FgR-49tCzqg">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The First Kumbal Procession 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/4aVWGhXuPys">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Second Kumbal Process 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/z2WNBORRpvk">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Third Kumbal Processio 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/ZO4rMQlnPmo">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Fourth Kumbal Processi 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/-2IyVoTqhCU">
                                                        <div class="index title">5</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Fifth Kumbal Procession 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/p8DADkBLxFk">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The First Randoli Procession 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="">
                                                        <div class="index title">8</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Second Randoli Procession 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="">
                                                        <div class="index title">9</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Third Randoli Procession 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="">
                                                        <div class="index title">10</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Fourth Randoli Procession 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/M9M90H3J-HM">
                                                        <div class="index title">11</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Grand Randoli Procession 2022 </div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/4rDSd9wG1pQ">
                                                        <div class="index title">12</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">The Day Procession 2023</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 2022 - Tamil -->
                        <div id="collapseOhree" class="accordion-collapse" aria-labelledby="headingOhree" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Kandy Esala Perahera 2022 (Tamil Narration)</h5>
                                <div id="playlist-2022-tamil">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2023 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2022"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/Wcg6EEF1h3k">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">முதல் கும்பல் பெரஹெரா 2022</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/ubO9V6_EBuc">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | இரண்</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/XK5CvCeupYw">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | மூன்</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/vGTsCeL8SHo">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | நான்</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/uX8DPxWgACc">
                                                        <div class="index title">5</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | மூன்</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/LItbQxz8e_M">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | முதலில் </div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/9G0J5SDxioo">
                                                        <div class="index title">8</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | இரண்</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/9nh-BRfHqYc">
                                                        <div class="index title">9</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | மூன்றா</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/j9gV7v3GSPg">
                                                        <div class="index title">10</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | ஐந்</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/CdXB9dyHOwM">
                                                        <div class="index title">11</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">கண்டி எசல பெரஹெரா 2022 | கிராண்ட் ரண்</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- 2022 - Multilingual -->
                        <div id="collapseOhree" class="accordion-collapse" aria-labelledby="headingOhree" mb-4>
                            <div class="accordion-body">
                                <h5 class="mt-4 text-center">Grand Randoli Perahera 2022 (Multilingual Narrations)</h5>
                                <div id="playlist-2022-mul">
                                    <div class="row">
                                        <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                            <div id="video-dis">
                                                <iframe id="display-frame" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-12 video-list-container">
                                            <div id="v-list" class="video-li">
                                                <div class="vli-info">
                                                    <div class="upper-info">
                                                        <div class="li-titles">
                                                            <div class="title">The Kandy Esala Perahera 2022 <span class="video-count"></span></div>
                                                        </div>
                                                        <div class="drop-icon" id="drop-icon-2022"></div>
                                                    </div>
                                                </div>
                                                <div class="vli-videos">
                                                    <div class="video-con active-con" data-video="https://www.youtube.com/embed/1onyl6IojrE">
                                                        <div class="index title">1</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/v8-APF8lPlY/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">Chinese ( 中國人 )</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/RzQhWiGzVyY">
                                                        <div class="index title">2</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/O3qXGl5hPKk/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">Hindi (हिन्दी)</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/lmJyS-zebJ4">
                                                        <div class="index title">3</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">Japanese (日本人)</div>
                                                        </div>
                                                    </div>
                                                    <div class="video-con" data-video="https://www.youtube.com/embed/CZcC3QMTSH4">
                                                        <div class="index title">4</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">German (Deutsch)</div>
                                                        </div>
                                                    </div>

                                                    <div class="video-con" data-video="https://www.youtube.com/embed/-tvqfzQA8qk">
                                                        <div class="index title">6</div>
                                                        <div class="thumb">
                                                            <img src="https://img.youtube.com/vi/3uByEpBX87g/hqdefault.jpg" alt="YouTube Thumbnail">
                                                        </div>
                                                        <div class="v-titles">
                                                            <div class="title">French</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    function setupPlaylist(playlistId, dropIconId) {
        const playlistContainer = document.querySelector(`#${playlistId}`);
        const vCons = playlistContainer.querySelectorAll(".video-con");
        const vCount = playlistContainer.querySelector(".video-count");
        const displayFrame = playlistContainer.querySelector("iframe");
        const dropIcon = document.querySelector(`#${dropIconId}`);
        const videoList = playlistContainer.querySelector(".vli-videos");

        function activate(con) {
            deactivateAll();
            indexAll();
            countVideos(con.querySelector(".index").innerHTML);
            con.classList.add("active-con");
            con.querySelector(".index").innerHTML = "►";
        }

        function deactivateAll() {
            vCons.forEach((container) => {
                container.classList.remove("active-con");
            });
        }

        function indexAll() {
            let i = 1;
            vCons.forEach((container) => {
                container.querySelector(".index").innerHTML = i;
                i++;
            });
        }

        function countVideos(active) {
            vCount.innerHTML = `${active} / ${vCons.length}`;
        }

        function loadVideo(url) {
            displayFrame.setAttribute("src", url);
        }

        function toggleList() {
            if (videoList.classList.contains("li-collapsed")) {
                dropIcon.style.transform = "rotate(0deg)";
                videoList.classList.remove("li-collapsed");
            } else {
                dropIcon.style.transform = "rotate(180deg)";
                videoList.classList.add("li-collapsed");
            }
        }

        // Initialize the playlist
        indexAll();
        countVideos(1);
        activate(vCons[0]);
        loadVideo(vCons[0].getAttribute("data-video"));

        // Event listeners
        vCons.forEach((container) => {
            container.addEventListener("click", () => {
                activate(container);
                loadVideo(container.getAttribute("data-video"));
            });
        });

        dropIcon.addEventListener("click", () => {
            toggleList();
        });
    }

    // Initialize multiple playlists by calling the function with each playlist ID and corresponding drop icon ID
    setupPlaylist("playlist-2024-sinhala", "drop-icon-2024");
    setupPlaylist("playlist-2024-english", "drop-icon-2024");
    setupPlaylist("playlist-2024-tamil", "drop-icon-2024");
    setupPlaylist("playlist-2024-mul", "drop-icon-2024");

    setupPlaylist("playlist-2023-sinhala", "drop-icon-2023");
    setupPlaylist("playlist-2023-english", "drop-icon-2023");
    setupPlaylist("playlist-2023-tamil", "drop-icon-2023");
    setupPlaylist("playlist-2023-mul", "drop-icon-2023");

    setupPlaylist("playlist-2022-sinhala", "drop-icon-2022");
    setupPlaylist("playlist-2022-english", "drop-icon-2022");
    setupPlaylist("playlist-2022-tamil", "drop-icon-2022");
    setupPlaylist("playlist-2022-mul", "drop-icon-2022");
</script>

<?php get_footer(); ?>