<?php
/*
Template Name: News Template
*/

get_header();
?>

<style>
    .news-archive-main {
        margin: 150px 0px;
    }
    .news-archive-year h3 {
        color: #ffd753;
        font-size: 2.5rem;
        text-align: center;
        padding: 30px 0px;
    }
     .card {
    /* background-color: #fff; */
    /* border-radius: 8px; */
    /* box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); */
    overflow: hidden;
    max-width: 350px;
    margin: 0px 2px;
    padding: 0px 0px;
    background-color: #000000;
    border: none;
    transition: transform 0.4s ease-in-out, box-shadow 0.4s ease-in-out; /* Smooth transition for card scaling and shadow */
  }
  
  /* Images */
  .card img {
    width: auto;
    height: 500px;
    object-fit: cover ;
    transition: transform 0.5s ease-in-out;
  }
.card:hover img {
    transform: scale(1.1); /* Scale the image to 110% when the card is hovered */
}

  
  /* Card Content */
  .card-content {
    padding: 5px;
    position:absolute;
    bottom: 0px;
    background: linear-gradient(0deg, rgba(33, 0, 0, 1) 10%, rgba(16330, 0, 0, 0.01) 30%);
    width: 100%;
    height: 100%;
    display: inline-flex;
    flex-direction: column;
    flex-wrap: wrap;
    justify-content: flex-end;
     transition: opacity 0.5s ease, background 0.5s ease;
  }

  .card-content:hover {
    /*background: linear-gradient(0deg, rgba(88, 25, 44, 1) 20%, rgba(88, 25, 44, 0.01) 30%);*/
    transition: background-image 0.7s cubic-bezier(0.250, 0.100, 0.250, 1.000);
    border: 1px solid white;
  }
  
  .card-content h3 {
    font-size: 1.1rem;
    margin-bottom: 10px;
    color: #fff;
  }
  
  .card-content p {
    font-size: 0.9rem;
    color: #dfdfdf;
  }
  
  /* Mobile Responsive */
  @media (max-width: 768px) {
    .card-section {
      flex-direction: column;
      align-items: center;
    }
    
    .card {
      width: 100%;
      max-width: 450px;
    }
  }

    .btn-read-more{
        background-color: transparent;
        border: 1px solid black;
    }
    .btn-read-more:hover{
        background-color: #FFD753;
        border: 1px solid black;
        color: #000;
    }

    .news-archive-year {
        margin-bottom: 50px;
    }

    .pagination {
        margin-top: 20px;
        text-align: center;
    }

    .pagination .page-numbers {
        color: #fff;
        border-color: #007bff;
        padding: 10px 15px;
        margin: 0 5px;
        border-radius: 5px;
        text-decoration: none;
    }

    .pagination .page-numbers.current {
        background-color: #ffd753;
        color: #000;
    }

    .pagination .page-numbers:hover {
        background-color: #ffd753;
        color: #000;
    }
</style>

<?php
function display_news_archives_with_pagination() {
    // Variables for pagination
    $global_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    // Fetch all posts ordered by date
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => -1, // Retrieve all posts for grouping by year
        'orderby' => 'date',
        'order' => 'DESC',
    );
    $query = new WP_Query($args);

    // Group posts by year
    $posts_by_year = [];
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $year = get_the_date('Y');
            $posts_by_year[$year][] = [
                'title' => get_the_title(),
                'date' => get_the_date(),
                'time' => get_the_time(),
                'excerpt' => get_the_excerpt(),
                'permalink' => get_permalink(),
                'thumbnail' => get_the_post_thumbnail_url(get_the_ID(), 'full'),
            ];
        }
    }

    // Reset post data
    wp_reset_postdata();

    echo '<div class="news-archive-main">';

    // Loop through each year and display posts
    foreach ($posts_by_year as $year => $posts) {
        // Get the paged parameter specific to each year
        $paged_key = 'paged_' . $year;
        $paged = isset($_GET[$paged_key]) ? intval($_GET[$paged_key]) : 1;

        echo '<div class="news-archive-year">';
        echo '<h3>' . esc_html($year) . ' Archives</h3>';

        // Paginate posts for each year
        $total_posts = count($posts);
        $posts_per_page = 8;
        $total_pages = ceil($total_posts / $posts_per_page);

        // Get the posts for the current page of the year
        $start = ($paged - 1) * $posts_per_page;
        $end = min($start + $posts_per_page, $total_posts);
        $paged_posts = array_slice($posts, $start, $posts_per_page);

        echo '<div class="row">';
        foreach ($paged_posts as $post) {
            ?>
            <div class="col-lg-3 col-sm-12 card-section">
                <a href="<?php echo esc_url($post['permalink']); ?>">
                <div class="card" style="width: 100%; height:450px;margin:10px 0px">
                    <img src="<?php echo esc_url($post['thumbnail']); ?>" alt="<?php echo esc_attr($post['title']); ?>">
                    <div class="card-content">
                        <h3 class="card-title text-center"><?php echo esc_html($post['title']); ?></h3>
                        <!-- <a href="<?php //echo esc_url($post['permalink']); ?>" class="btn btn-read-more">Read More</a> -->
                         <p class="m-0 p-0 text-center"><?php echo esc_html($post['date'] . " | " . $post['time']); ?></p>
                    </div>
                </div>
                </a>
            </div>
            <?php
        }
        echo '</div>'; // end row

        // Pagination for each year's posts
        if ($total_pages > 1) {
            echo '<nav aria-label="Page navigation">';
            echo '<ul class="pagination justify-content-center">';

            $pagination_links = paginate_links(array(
                'base' => add_query_arg($paged_key, '%#%'),
                'format' => '?'. $paged_key . '=%#%',
                'current' => max(1, $paged),
                'total' => $total_pages,
                'prev_text' => __('« Previous'),
                'type' => 'array', // Return the links as an array
            ));

            if ($pagination_links) {
                foreach ($pagination_links as $link) {
                    echo '<li class="page-item">' . $link . '</li>';
                }
            }

            echo '</ul>';
            echo '</nav>';
        }

        echo '</div>'; // end year archive section
    }

    echo '</div>';
}

display_news_archives_with_pagination();
?>

<?php get_footer(); ?>
