<?php
/*
Template Name: Home Template
*/

get_header(); ?>

<style>
    @media screen and (max-width: 600px) {
        .add-to-cal-section {
            margin: 25px 0px 0px 0px;
            flex-wrap: wrap;
        }
    }

    a {
        text-decoration: none;
    }

    .grid-tile {
        padding: 10px;
        display: inline-flex;
        flex-wrap: nowrap;
        align-items: center;
        gap: 5px;
    }

    .grid-tile:hover {
        background-color: #ea4335;
        border-radius: 99.9em;
        padding: 10px;
        transition-duration: 0.5s;
    }

    .grid-title .icon {
        display: flex;
        align-self: stretch;
        justify-content: center;
        align-items: center;
        width: 4.5em;
        position: relative;
        color: #fff;
    }

    .grid-title .icon svg {
        font-size: 10px;
    }

    .grid-title .text {
        font-size: 1.5em;
        padding-inline-end: 1em;
        align-self: stretch;
        flex-grow: 1;
        align-items: center;
        display: flex;
        font-weight: 100;
    }

    .social-links {
        display: flex;
        align-items: center;
        flex-wrap: wrap;
        justify-content: center;
    }

    .add-to-cal-section {
        display: flex;
        text-align: center;
        align-items: center;
        justify-content: center;
        margin: 15px 0px;
        gap: 25px;
    }

    .add-to-btn {
        border-color: white;
        border-radius: 0px;
        padding: 8px 28px;
    }

    .add-to-btn:hover {
        border-color: white;
        border-radius: 0px;
        background-color: #A15E00;
    }

    /* Date Count css */
    .swiper-text {
        flex-direction: column;
    }
    
    @media screen and (min-width: 768px) and (max-width: 992px) {
    .swiper-text .text-wrap {
        font-size: 3rem;
    }
}
    
    @import url("https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700;900&family=Crimson+Text:wght@400;600&display=swap");

    .countdown-container {
        /* background: white;
        border-radius: 20px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1); */
        /*padding: 50px 0px;*/
        text-align: center;
        max-width: 500px;
        width: 100%;
        position: absolute;
        top:8rem;
        overflow: hidden;
    }

    .countdown-display {
        text-align: center;
        /*margin: 40px 0;*/
    }

    .time-number {
        font-family: "Playfair Display", serif;
        font-size: 10rem;
        font-weight: 900;
        color: white;
        line-height: 1;
        /* margin-bottom: 15px;*/
        text-shadow:2px 2px 2px #8B0000;
    }

    .time-label {
        font-family: "Crimson Text", serif;
        font-size: 1.4rem;
        font-weight:bolder;
        color: white;
        letter-spacing: 1px;
    }

    .event-date {
        font-family: "Crimson Text", serif;
        font-size: 1.1rem;
        color: #6b7280;
        margin-top: 30px;
        font-style: italic;
    }

    @media (max-width: 768px) {
        .countdown-container {
            padding: 40px 20px;
            position:relative;
            top:auto;
        }

        .event-title {
            font-size: 1.8rem;
        }

        .time-number {
            font-size: 8rem;
        }
    }
</style>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/slider.css">

<!-- Slick Slider -->
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css" />
<!-- jQuery (if not already included) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Slick Slider JS -->
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>

<div id="primary" class="content-area">
    <main id="main" class="site-main" role="main">


        <div class="hero-section h-screen w-auto">
            <div class="swiper mySwiper">
                <div class="swiper-text">
                    <h4 class="text-wrap">The Kandy Esala Perahera</h4>
                    <div class="countdown-container">
                        <div class="countdown-display">
                            <div class="time-number" id="days">58</div>
                            <div class="time-label">More Days</div>
                        </div>
                    </div>
                </div>
                <div class="swiper-wrapper">
                    <div class="swiper-slide slide-01">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Main_slider/h1.jpg" alt="" class="bg-blend-darken">
                    </div>
                    <div class="swiper-slide slide-02">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Main_slider/h2.jpg" alt="">
                    </div>
                    <!--<div class="swiper-slide slide-03">-->
                    <!--    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Main_slider/h3.jpg" alt="">-->
                    <!--</div>-->
                    <div class="swiper-slide slide-04">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Main_slider/h4.jpg" alt="">
                    </div>
                </div>
                <div class="swiper-pagination"></div>
                <div class="autoplay-progress"></div>
            </div>
        </div>


        <div class="container details-container my-5">
            <div class="row">
                <div class="description col-lg-7 p-2">
                    <h3 class="text-center text-wrap">The Most Historical Cultural procession of the World</h3>
                    <hr>
                    <p class="text-left">Buddhist Literature unveils various pageants and festivities held in great honor of Lord Buddha.
                        The perahara pageant concept became popular during the reign of Emperor Asoka of India.
                        Kandy Perahara pageant really pageant which displays traditional customs. Majority of them been intermingled with the Buddhist and Hindu religious customs.
                    </p>
                    <p class="text-left">Yet they display and highlight the great value of the Sinhala culture.
                        Most of the customs have taken from on statues stated in the “Dantha Dhathu Charitha” or “Dalada Siritha”
                        (a book on the customs pertaining on the sacred Tooth Relic) Written during the regime of Parakramabahu IV (1302-1326) of Kurunagala.
                    </p>
                    <p class="text-left">
                        The Dalada Siritha stated 38 statutes, on which a Perahara pageant should be conducted. Accordingly,
                        the Shrine Room of the Sacred Tooth Relic should be cleaned at the auspicious hour. canopies should be tied,
                        should be decorated beautifully with various silk clothes; The king team of ministers and general public of the city should make offering of rice,
                        flowers and light oil lamps on the 7th day morning, the city should be decorated like the heaven on the same day evening,
                        the chief priests of Uttara Mula Sect personnel of two castes Ganavesi and Kilin should move the Sacred Relic casked with utmost veneration.
                    </p>
                    <p class="text-left">
                        These rites were performed annually. Even today rights were performed accordingly.
                    </p>
                </div>

                <div class="description-imgs col-lg-5">
                    <img decoding="async" width="525" height="315" src="https://kandyesalaperahera.com/wp-content/uploads/2021/07/kandy-dalada-perahera.jpg" class="d-img" alt="kandy-dalada-perahera" srcset="https://kandyesalaperahera.com/wp-content/uploads/2021/07/kandy-dalada-perahera.jpg 700w, https://kandyesalaperahera.com/wp-content/uploads/2021/07/kandy-dalada-perahera-600x386.jpg 600w, https://kandyesalaperahera.com/wp-content/uploads/2021/07/kandy-dalada-perahera-300x193.jpg 300w" sizes="(max-width: 700px) 100vw, 700px">
                    <img loading="lazy" decoding="async" width="525" height="315" src="https://kandyesalaperahera.com/wp-content/uploads/2021/05/Old-perhara3-2.png" class="d-img" alt="Old-perhara3-2" srcset="https://kandyesalaperahera.com/wp-content/uploads/2021/05/Old-perhara3-2.png 525w, https://kandyesalaperahera.com/wp-content/uploads/2021/05/Old-perhara3-2-300x180.png 300w" sizes="(max-width: 525px) 100vw, 525px">
                </div>
            </div>
        </div>

        <section class="ps-timeline-sec">
            <div class="container">
                <h3 class="text-center">Time Line</h3>
                <ol class="ps-timeline">
                    <li>
                        <div class="img-handler-top">
                            <h4>Old Ritual of Esala Perahera</h4>
                            <p>A ritual called the Esala Perahera is performed to askthe gods for rain.</p>
                        </div>

                        <span class="ps-sp-top">200 B.C.</span>
                    </li>
                    <li>
                        <div class="img-handler-bot">
                            <h4>Tooth Relic is Brought to Sri Lanka</h4>
                            <p>The Sacred Tooth Relic of Buddha is transported from India to Sri Lanka 800 years after his death.

                            </p>
                        </div>

                        <span class="ps-sp-bot">300 A.D.
                        </span>
                    </li>
                    <li>
                        <div class="img-handler-top">
                            <h4>‘Fa Hien’</h4>
                            <p>The book of Chinese pilgrim ‘Fa Hien,’ who traveled to Sri Lanka in the fifth century A.D., contains the most illuminating account of the Esala Perehera.</p>
                        </div>
                        <span class="ps-sp-top">400 A.D.
                        </span>
                    </li>
                    <li>
                        <div class="img-handler-bot">

                        </div>
                        <div class="img-handler-bot">
                            <h4>Custody of the Tooth Relic</h4>
                            <p>When the Kandyan kingdom is conquered by the British, the Buddhist clergy is given custody of the Tooth Relic.

                            </p>
                        </div>
                        <span class="ps-sp-bot">1815</span>
                    </li>

                </ol>
            </div>
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">
                <path class="elementor-shape-fill" d="M1000,4.3V0H0v4.3C0.9,23.1,126.7,99.2,500,100S1000,22.7,1000,4.3z"></path>
            </svg>
        </section>

        <div class="container-fluid time-table-body">
            <div class="container time-table">
                <div class="row">
                    <div class="col-12 text-center d-flex align-items-center flex-column">
                        <h3>The Kandy Esala Perahera Festival 2025</h3>
                        <h6>Here are the Scheduled Dates.</h6>
                        <table class="dates-table mt-5">
                            <thead>
                                <tr class="bg-00">
                                    <th>EVENT</th>
                                    <th>DATE</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="bg-01">
                                    <td>1st Kumbal Perahera</td>
                                    <td>30th July 2025</td>
                                </tr>
                                <tr class="bg-02">
                                    <td>2nd Kumbal Perahera</td>
                                    <td>31st July 2025</td>
                                </tr>
                                <tr class="bg-01">
                                    <td>03rd Kumbal Perahera</td>
                                    <td>01st August 2025</td>
                                </tr>
                                <tr class="bg-02">
                                    <td>04th Kumbal Perahera</td>
                                    <td>02nd August 2025</td>
                                </tr>
                                <tr class="bg-01">
                                    <td>05th Kumbal Perahera</td>
                                    <td>03rd August 2025</td>
                                </tr>
                                <tr class="bg-02">
                                    <td>01st Randoli Perahera</td>
                                    <td>04th August 2025</td>
                                </tr>
                                <tr class="bg-01">
                                    <td>02nd Randoli Perahera</td>
                                    <td>05th August 2025</td>
                                </tr>
                                <tr class="bg-02">
                                    <td>03rd Randoli Perahera</td>
                                    <td>06th August 2025</td>
                                </tr>
                                <tr class="bg-01">
                                    <td>04th Randoli Perahera</td>
                                    <td>07th August 2025</td>
                                </tr>
                                <tr class="bg-02">
                                    <td>Final Randoli Perahera (The Grand Randoli Procession)</td>
                                    <td>08th August 2025</td>
                                </tr>
                                <tr class="bg-01">
                                    <td>Diya Kapeema (The water cutting ceremony)</td>
                                    <td>09th August 2025</td>
                                </tr>
                                <tr class="bg-02">
                                    <td>Dahawal Perahera (The Day Procession)</td>
                                    <td>09th August 2025</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-12 text-center">
                        <a type="button" class="btn text-white text-center my-2 add-to-btn" href="https://calendar.google.com/calendar/u/5/r?cid=ZGRkNzg1NTQwNGE2ZTc0NDJlMTcyNmY5ZGRkYzgwYmEyOGNiZTcwODg0YjEyM2E0YTIyZDgwNWFmOWM4MDAyMkBncm91cC5jYWxlbmRhci5nb29nbGUuY29t" target="blank" rel="noopener">Add to calendar</a>

                        <div class="social-links">
                            <a href="https://www.facebook.com/sridaladamaligawa/" target="blank">
                                <span class=add-to-cal-section>
                                    <div class="grid-tile">
                                        <span class="icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                                                <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                                            </svg> </span>
                                        <span class="text">Facebook</span>
                                    </div></a>
                            <a href="https://api.whatsapp.com/send?text=*Official%20Event%20Dates%202025%20%7C%20Kandy%20Esala%20Perahera*%0A%0Ahttps://kandyesalaperahera.com/dates2025/" target="blank">
                                <div class="grid-tile">
                                    <span class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-whatsapp" viewBox="0 0 16 16">
                                            <path d="M13.601 2.326A7.85 7.85 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.9 7.9 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.9 7.9 0 0 0 13.6 2.326zM7.994 14.521a6.6 6.6 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.56 6.56 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592m3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.73.73 0 0 0-.529.247c-.182.198-.691.677-.691 1.654s.71 1.916.81 2.049c.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232" />
                                        </svg> </span>
                                    <span class="text">WhatsApp</span>
                                </div>
                            </a>
                            <a href="https://telegram.me/share/url?url=https://kandyesalaperahera.com/dates2025/&text=" target="blank">
                                <div class="grid-tile">
                                    <span class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-telegram" viewBox="0 0 16 16">
                                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.287 5.906q-1.168.486-4.666 2.01-.567.225-.595.442c-.03.243.275.339.69.47l.175.055c.408.133.958.288 1.243.294q.39.01.868-.32 3.269-2.206 3.374-2.23c.05-.012.12-.026.166.016s.042.12.037.141c-.03.129-1.227 1.241-1.846 1.817-.193.18-.33.307-.358.336a8 8 0 0 1-.188.186c-.38.366-.664.64.015 1.088.327.216.589.393.85.571.284.194.568.387.936.629q.14.092.27.187c.331.236.63.448.997.414.214-.02.435-.22.547-.82.265-1.417.786-4.486.906-5.751a1.4 1.4 0 0 0-.013-.315.34.34 0 0 0-.114-.217.53.53 0 0 0-.31-.093c-.3.005-.763.166-2.984 1.09" />
                                        </svg> </span>
                                    <span class="text">Telegram</span>
                                </div>
                            </a>
                            <a href="https://x.com/intent/post?text=+https%3A%2F%2Fkandyesalaperahera.com%2Fdates2025%2F" target="blank">
                                <div class="grid-tile">
                                    <span class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                                            <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                                        </svg> </span>
                                    <span class="text">X</span>
                                </div>
                                <a href="mailto:kandyesalaperahera@sridaladamalaigawa.lk">
                                    <div class="grid-tile">
                                        <span class="icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-envelope-fill" viewBox="0 0 16 16">
                                                <path d="M.05 3.555A2 2 0 0 1 2 2h12a2 2 0 0 1 1.95 1.555L8 8.414zM0 4.697v7.104l5.803-3.558zM6.761 8.83l-6.57 4.027A2 2 0 0 0 2 14h12a2 2 0 0 0 1.808-1.144l-6.57-4.027L8 9.586zm3.436-.586L16 11.801V4.697z" />
                                            </svg> </span>
                                        <span class="text">Email</span>
                                    </div>
                                </a>
                                <a href="javascript:if(window.print)window.print()">
                                    <div class="grid-tile">
                                        <span class="icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-printer-fill" viewBox="0 0 16 16">
                                                <path d="M5 1a2 2 0 0 0-2 2v1h10V3a2 2 0 0 0-2-2zm6 8H5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1" />
                                                <path d="M0 7a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2h-1v-2a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v2H2a2 2 0 0 1-2-2zm2.5 1a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1" />
                                            </svg> </span>
                                        <span class="text">Print</span>
                                    </div>
                                    </span>
                        </div></a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container news-container">
            <div class="row">
                <div class="col-12 text-center">
                    <h3>News and Event Updates</h3>
                    <h6>From the 2024 Event</h6>
                </div>
                <div class="col-12">
                    <div class="container">
                        <div class="row">
                            <?php
                            // Custom query to get the latest 4 news posts
                            $args = array(
                                'post_type'      => 'post', // Change to your custom post type if needed
                                'posts_per_page' => 4,
                                'orderby'       => 'date',
                                'order'         => 'DESC'
                            );
                            $query = new WP_Query($args);

                            // Loop through the posts
                            if ($query->have_posts()) :
                                while ($query->have_posts()) : $query->the_post(); ?>
                                    <div class="card-section col-lg-3 col-sm-6">
                                        <a href="<?php the_permalink(); ?>" class="card-link">
                                            <div class="card">
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php the_title_attribute(); ?>">
                                                <?php else: ?>
                                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/default.jpg" alt="Default Image">
                                                <?php endif; ?>
                                                <div class="card-content">
                                                    <h3 class="p-0 m-0 text-center"><?php the_title(); ?></h3>
                                                    <p class="p-0 m-0 text-center"><?php the_date('F j, Y, g:i A'); ?></p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                            <?php endwhile;
                                wp_reset_postdata(); // Restore original post data
                            else :
                                echo '<p>No news found</p>';
                            endif; ?>

                        </div>
                        <div class="row">
                            <div class="col-12 text-center my-5">
                                <a href="https://kandyesalaperahera.com/news/" type="button" class="btn text-center white-btn"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-newspaper mx-2" viewBox="0 0 16 16">
                                        <path d="M0 2.5A1.5 1.5 0 0 1 1.5 1h11A1.5 1.5 0 0 1 14 2.5v10.528c0 .3-.05.654-.238.972h.738a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 1 1 0v9a1.5 1.5 0 0 1-1.5 1.5H1.497A1.497 1.497 0 0 1 0 13.5zM12 14c.37 0 .654-.211.853-.441.092-.106.147-.279.147-.531V2.5a.5.5 0 0 0-.5-.5h-11a.5.5 0 0 0-.5.5v11c0 .278.223.5.497.5z" />
                                        <path d="M2 3h10v2H2zm0 3h4v3H2zm0 4h4v1H2zm0 2h4v1H2zm5-6h2v1H7zm3 0h2v1h-2zM7 8h2v1H7zm3 0h2v1h-2zm-3 2h2v1H7zm3 0h2v1h-2zm-3 2h2v1H7zm3 0h2v1h-2z" />
                                    </svg>More News</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid photo-gallery">
            <div class="row">
                <div class="col-12">
                    <h3>Photo Gallery</h3>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/Tuskers.png" alt="">
                    <div class="overlay"></div>
                    <div class="text">Tuskers</div>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/03.jpg" alt="">
                    <div class="overlay"></div>
                    <div class="text">Perahera Events</div>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/04.jpg" alt="">
                    <div class="overlay"></div>
                    <div class="text">Dancers</div>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/02.jpg" alt="">
                    <div class="overlay"></div>
                    <div class="text">Drummers</div>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/05.jpg" alt="">
                    <div class="overlay"></div>
                    <div class="text">Dancers</div>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/06.jpg" alt="">
                    <div class="overlay"></div>
                    <div class="text">Dancers</div>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/07.jpg" alt="">
                    <div class="overlay"></div>
                    <div class="text">Fire Dancers</div>
                </div>
                <div class="col-lg-3 col-md-6 img-col">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Images/8.jpg" alt="">
                    <div class="overlay"></div>
                    <div class="text">Dancers</div>
                </div>
                <div class="col-12 text-center my-5">
                    <a href="https://kandyesalaperahera.com/image-gallery/" type="button" class="btn text-center white-btn"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-images mx-2" viewBox="0 0 16 16">
                            <path d="M4.502 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3" />
                            <path d="M14.002 13a2 2 0 0 1-2 2h-10a2 2 0 0 1-2-2V5A2 2 0 0 1 2 3a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v8a2 2 0 0 1-1.998 2M14 2H4a1 1 0 0 0-1 1h9.002a2 2 0 0 1 2 2v7A1 1 0 0 0 15 11V3a1 1 0 0 0-1-1M2.002 4a1 1 0 0 0-1 1v8l2.646-2.354a.5.5 0 0 1 .63-.062l2.66 1.773 3.71-3.71a.5.5 0 0 1 .577-.094l1.777 1.947V5a1 1 0 0 0-1-1z" />
                        </svg>More Images</a>
                </div>
            </div>
        </div>

        <div class="container my-5">
            <hr>
        </div>

        <div class="container-fluid">
            <h3 class="text-center">The Kandy Esala Perahera Meritorious sponsors</h3>
            <div class="sponsor-slider-wrapper">
                <div class="sponsor-slider">
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/boc.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/ceylon-tea.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/Lanka-Oil.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/sand-1.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/gem-and-jewellery.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/maha-barakaara.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/sri-lanka-youth.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/sathosa.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/so-sri-lanka.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/laugfs.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/singer.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/maliban-1.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/fontera-1.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/peoples-insu.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/peoples-leasing.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/lottery.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/slic.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/dlb-1 (1).png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/unilever-1.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/dialog-1.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/nestle-2.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/SLTMobitel.png" alt="">
                    </div>
                    <div class="item">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Sponsors_slider/peoplesbnk-1-300x300aa (1).png" alt="">
                    </div>
                </div>
            </div>
        </div>

    </main><!-- #main -->
</div><!-- #primary -->


<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<!-- Initialize Swiper -->
<script>
    const progressCircle = document.querySelector(".autoplay-progress svg");
    const progressContent = document.querySelector(".autoplay-progress span");
    var swiper = new Swiper(".mySwiper", {
        spaceBetween: 0,
        centeredSlides: true,
        autoplay: {
            delay: 2500,
            disableOnInteraction: false,
        },

        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
    });
</script>

<!-- slick slider script -->
<script>
    jQuery(document).ready(function($) {
        $('.sponsor-slider').slick({
            infinite: true,
            slidesToShow: 6,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 1000,
            dots: false,
            arrows: false,
            draggable: true,
            responsive: [{
                    breakpoint: 1024,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                }
            ]
        });
    });

    // date count script
    // Set the starting countdown date - this will countdown from 58 days
    const startDate = new Date('2025-06-03'); // Starting date (today)
    const startingDays = 58; // Starting countdown value

    function updateDisplay() {
        const today = new Date();
        const daysPassed = Math.floor((today - startDate) / (1000 * 60 * 60 * 24));
        const remainingDays = Math.max(0, startingDays - daysPassed);

        document.getElementById('days').textContent = remainingDays;
    }

    function updateCountdown() {
        const title = document.getElementById('titleInput').value;
        const days = document.getElementById('daysInput').value;

        if (title) {
            document.getElementById('eventTitle').textContent = title;
        }

        if (days && days >= 0) {
            // Update the display with manual input
            document.getElementById('days').textContent = days;
        } else {
            // Show the auto-updating countdown
            updateDisplay();
        }
    }

    // Initialize display
    updateDisplay();

    // Update once per day (check every hour for accuracy)
    setInterval(updateDisplay, 1000 * 60 * 60); // Update every hour
</script>


<?php //get_sidebar(); 
?>
<?php get_footer(); ?>