<?php
// Shortcode to display playlists without accordion
function evp_display_playlists($atts)
{
    $playlists = get_option('evp_playlists', '{}');
    $playlists = json_decode($playlists, true);

    if (!$playlists) {
        return '<p>No playlists available.</p>';
    }

    $output = '<div class="container mt-4 video-main-container">';

    ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <?php

    foreach ($playlists as $event) {
        $output .= '
        <div class="playlist-container my-4">
            <h2 class="playlist-title">' . esc_html($event['title']) . '</h2>
            <div id="playlist-' . esc_attr($event['id']) . '">
                <div class="row">
                    <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                        <div id="video-dis">
                            <iframe id="display-frame-' . esc_attr($event['id']) . '" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 video-list-container">
                        <div id="v-list" class="video-li">
                            <div class="vli-info">
                                <div class="upper-info">
                                    <div class="li-titles">
                                        <div class="title">Video List<span class="video-count"></span></div>
                                    </div>
                                    <div class="drop-icon" id="drop-icon-' . esc_attr($event['id']) . '"></div>
                                </div>
                            </div>
                            <div id="lower-info">
                                <div id="btn-repeat"><i class="fa fa-repeat" aria-hidden="true"></i></div>
                                <div id="btn-suffle"><i class="fa fa-random" aria-hidden="true"></i></div>
                                <div id="btn-save"><i class="fa fa-bookmark" aria-hidden="true"></i></div>
                            </div>
                            <div class="vli-videos">';

        foreach ($event['videos'] as $index => $video) {
            $output .= '
            <div class="video-con" data-video="' . esc_url($video['url']) . '">
                <div class="index title">' . ($index + 1) . '</div>
                <div class="thumb"><img src="' . esc_url($video['thumbnail']) . '" alt="YouTube Thumbnail"></div>
                <div class="v-titles"><div class="title">' . esc_html($video['title']) . '</div></div>
            </div>';
        }

        $output .= '
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>';

        // Add JavaScript to call the setupPlaylist function for each playlist
        $output .= '
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                setupPlaylist("playlist-' . esc_js($event['id']) . '", "drop-icon-' . esc_js($event['id']) . '", "display-frame-' . esc_js($event['id']) . '");
            });
        </script>';
    }

    $output .= '</div>';

    return $output;
}
add_shortcode('event_video_playlists', 'evp_display_playlists');
?>

