<?php

// Add a submenu in the admin panel
function evp_add_admin_menu() {
    add_menu_page('Event Video Playlist', 'Video Playlists', 'manage_options', 'evp_playlist', 'evp_admin_page', 'dashicons-video-alt2', 20);
}
add_action('admin_menu', 'evp_add_admin_menu');

// Admin page content
function evp_admin_page() {
    ?>
    <div class="wrap">
        <h1>Add Event Playlist</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('evp_settings_group');
            do_settings_sections('evp_playlist');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// Register settings
function evp_register_settings() {
    register_setting('evp_settings_group', 'evp_playlists');
    add_settings_section('evp_main_section', 'Event Playlists', null, 'evp_playlist');
    add_settings_field('evp_playlists_field', 'Add Playlists (JSON)', 'evp_playlists_field_cb', 'evp_playlist', 'evp_main_section');
}
add_action('admin_init', 'evp_register_settings');

// Input field for JSON playlists
function evp_playlists_field_cb() {
    $playlists = get_option('evp_playlists', '{}');
    echo '<textarea name="evp_playlists" rows="10" cols="50" class="large-text code">' . esc_textarea($playlists) . '</textarea>';
}
