function setupPlaylist(playlistId, dropIconId, frameId) {
    const playlistContainer = document.querySelector(`#${playlistId}`);
    const vCons = playlistContainer.querySelectorAll(".video-con");
    const vCount = playlistContainer.querySelector(".video-count");
    const displayFrame = document.querySelector(`#${frameId}`);
    const dropIcon = document.querySelector(`#${dropIconId}`);
    const videoList = playlistContainer.querySelector(".vli-videos");

    // Buttons
    const btnRepeat = playlistContainer.querySelector("#btn-repeat");
    const btnShuffle = playlistContainer.querySelector("#btn-suffle");
    const btnSave = playlistContainer.querySelector("#btn-save");

    let repeatMode = false;
    let shuffleMode = false;
    let savedVideo = false;

    // Load state from localStorage (if exists)
    repeatMode = localStorage.getItem("repeatMode") === "true";
    shuffleMode = localStorage.getItem("shuffleMode") === "true";
    savedVideo = localStorage.getItem("savedVideo");

    // Apply saved states to buttons
    if (repeatMode) {
        btnRepeat.classList.add("active");
    }
    if (shuffleMode) {
        btnShuffle.classList.add("active");
    }
    if (savedVideo) {
        btnSave.classList.add("active");
    }

    function activate(con) {
        deactivateAll();
        indexAll();
        countVideos(con.querySelector(".index").innerHTML);
        con.classList.add("active-con");
        con.querySelector(".index").innerHTML = "►";
    }

    function deactivateAll() {
        vCons.forEach((container) => {
            container.classList.remove("active-con");
        });
    }

    function indexAll() {
        let i = 1;
        vCons.forEach((container) => {
            container.querySelector(".index").innerHTML = i;
            i++;
        });
    }

    function countVideos(active) {
        vCount.innerHTML = `${active} / ${vCons.length}`;
    }

    function loadVideo(url) {
        displayFrame.setAttribute("src", url);
    }

    function toggleList() {
        if (videoList.classList.contains("li-collapsed")) {
            dropIcon.style.transform = "rotate(0deg)";
            videoList.classList.remove("li-collapsed");
        } else {
            dropIcon.style.transform = "rotate(180deg)";
            videoList.classList.add("li-collapsed");
        }
    }

    function nextVideo() {
        if (shuffleMode) {
            currentVideoIndex = Math.floor(Math.random() * vCons.length);
        } else {
            currentVideoIndex = (currentVideoIndex + 1) % vCons.length;
        }
        activate(vCons[currentVideoIndex]);
        loadVideo(vCons[currentVideoIndex].getAttribute("data-video"));
    }

    function repeatCurrentVideo() {
        // Repeat the current video
        if (repeatMode) {
            loadVideo(vCons[currentVideoIndex].getAttribute("data-video"));
        } else {
            nextVideo();
        }
    }

    // Event listeners for video switching
    vCons.forEach((container, index) => {
        container.addEventListener("click", () => {
            currentVideoIndex = index;
            activate(container);
            loadVideo(container.getAttribute("data-video"));
        });
    });

    dropIcon.addEventListener("click", () => {
        toggleList();
    });

    // Button functionality with localStorage and color changes
    btnRepeat.addEventListener("click", () => {
        repeatMode = !repeatMode;
        btnRepeat.classList.toggle('active', repeatMode); // Toggle active class
        localStorage.setItem("repeatMode", repeatMode); // Save state
    });

    btnShuffle.addEventListener("click", () => {
        shuffleMode = !shuffleMode;
        btnShuffle.classList.toggle('active', shuffleMode); // Toggle active class
        localStorage.setItem("shuffleMode", shuffleMode); // Save state
    });

    btnSave.addEventListener("click", () => {
        btnSave.classList.add('active'); // Indicate the video is saved
        localStorage.setItem("savedVideo", true); // Save state
        setTimeout(() => btnSave.classList.remove('active'), 1000); // Flash effect for save
    });

    // Initialize the playlist
    indexAll();
    countVideos(1);
    activate(vCons[0]);
    loadVideo(vCons[0].getAttribute("data-video"));
}
